<?php
$anime = isset($_GET['anime']) ? urldecode($_GET['anime']) : '';
$ep = isset($_GET['ep']) ? (int)$_GET['ep'] : 1;
$dir = 'animes/' . $anime;

// Security check
if (strpos($anime, '..') !== false || empty($anime) || !is_dir($dir)) {
    header("Location: index.php");
    exit;
}

// Find files
$files = scandir($dir);
$episodes = [];
foreach($files as $f) {
    if(preg_match('/\.(mp4|mkv|webm)$/i', $f)) {
        if (preg_match('/(\d+)/', $f, $matches)) {
            $epNum = (int)$matches[1];
            $episodes[$epNum] = $f;
        }
    }
}
ksort($episodes);

// Smart Navigation
$epKeys = array_keys($episodes);
$currentKeyIndex = array_search($ep, $epKeys);

$prevEp = ($currentKeyIndex !== false && $currentKeyIndex > 0) ? $epKeys[$currentKeyIndex - 1] : null;
$nextEp = ($currentKeyIndex !== false && $currentKeyIndex < count($epKeys) - 1) ? $epKeys[$currentKeyIndex + 1] : null;

$currentVideo = isset($episodes[$ep]) ? $dir . '/' . $episodes[$ep] : '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Watch <?php echo htmlspecialchars($anime); ?> - Episode <?php echo $ep; ?></title>
    <link rel="stylesheet" href="assets/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>

    <header>
        <div class="container header-content">
            <a href="index.php" class="logo">Nonton<span>Anime</span></a>
            <div class="header-right">
                <div class="theme-switch-wrapper">
                    <label class="theme-switch" for="checkbox">
                        <input type="checkbox" id="checkbox" />
                        <div class="slider">
                            <i class="fas fa-sun slider-icon sun-icon"></i>
                            <i class="fas fa-moon slider-icon moon-icon"></i>
                        </div>
                    </label>
                </div>
            </div>
        </div>
    </header>

    <main class="container player-container" style="min-height: 80vh;">
        
        <div class="mb-4 mt-4">
            <a href="index.php" class="text-secondary" style="text-decoration: none; font-size: 0.9rem;">
                <i class="fas fa-arrow-left"></i> Back to Home
            </a>
            <h1 class="mt-2" style="font-size: 1.5rem; color: var(--text-primary);">
                <?php echo htmlspecialchars($anime); ?> <span class="text-secondary">- Episode <?php echo $ep; ?></span>
            </h1>
        </div>

        <?php if ($currentVideo && file_exists($currentVideo)): ?>
            <div class="video-wrapper">
                <video controls autoplay>
                    <source src="<?php echo htmlspecialchars($currentVideo); ?>" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
            </div>
        <?php else: ?>
            <div class="p-4" style="background: var(--card-bg); border: 1px solid var(--border); border-radius: 8px; text-align: center; padding: 4rem 2rem;">
                <h2 style="color: var(--accent); margin-bottom: 1rem;">Episode Not Found</h2>
                <p class="text-secondary">We couldn't find the video file for Episode <?php echo $ep; ?>.</p>
                <div class="mt-4">
                    <a href="index.php" class="btn btn-secondary">Go Home</a>
                </div>
            </div>
        <?php endif; ?>

        <div class="controls">
            <div>
                <?php if ($prevEp): ?>
                    <a href="watch.php?anime=<?php echo urlencode($anime); ?>&ep=<?php echo $prevEp; ?>" class="btn btn-secondary">
                        <i class="fas fa-step-backward" style="margin-right: 8px;"></i> Previous
                    </a>
                <?php else: ?>
                    <button class="btn btn-secondary" disabled>Previous</button>
                <?php endif; ?>
            </div>

            <div>
                 <button class="btn btn-secondary" style="background: transparent; border: 1px solid var(--border);">
                    <i class="fas fa-list" style="margin-right: 8px;"></i> Episodes
                 </button>
            </div>

            <div>
                <?php if ($nextEp): ?>
                    <a href="watch.php?anime=<?php echo urlencode($anime); ?>&ep=<?php echo $nextEp; ?>" class="btn btn-primary">
                        Next <i class="fas fa-step-forward" style="margin-left: 8px;"></i>
                    </a>
                <?php else: ?>
                    <button class="btn btn-primary" disabled>Next</button>
                <?php endif; ?>
            </div>
        </div>

        <!-- Episode List Grid -->
        <div class="mt-4 mb-5">
             <h3 class="mb-2" style="font-size: 1.1rem;">All Episodes</h3>
             <div class="anime-grid" style="grid-template-columns: repeat(auto-fill, minmax(80px, 1fr)); gap: 0.5rem;">
                <?php foreach($episodes as $num => $file): ?>
                    <a href="watch.php?anime=<?php echo urlencode($anime); ?>&ep=<?php echo $num; ?>" 
                       class="btn <?php echo $num === $ep ? 'btn-primary' : 'btn-secondary'; ?>"
                       style="justify-content: center; width: 100%;">
                        <?php echo $num; ?>
                    </a>
                <?php endforeach; ?>
             </div>
        </div>

    </main>

    <footer>
        <div class="container">
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> NontonAnime. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="assets/script.js"></script>
</body>
</html>
