<?php
// Scan directory once
$dir = 'animes';
$animes = [];
if (is_dir($dir)) {
    $animes = array_filter(scandir($dir), function($item) use ($dir) {
        return $item !== '.' && $item !== '..' && is_dir($dir . '/' . $item);
    });
}
// Randomize for variety
shuffle($animes);

// Hero Anime (First one after shuffle)
$heroAnime = !empty($animes) ? $animes[0] : null;

// Recommendations (Next 4)
$recommendations = array_slice($animes, 1, 4);

// Main List (All, maybe re-sorted or just randomized)
// Let's keep the shuffled order for "Latest Updates" feel
$mainList = $animes; 

function getPoster($path) {
    $potential = ['poster.jpg', 'poster.png', 'cover.jpg'];
    foreach ($potential as $p) {
        if (file_exists($path . '/' . $p)) {
            return $path . '/' . $p;
        }
    }
    return 'assets/placeholder.jpg';
}

function getEpisodeCount($path) {
    if (!is_dir($path)) return 0;
    $files = scandir($path);
    $count = 0;
    foreach($files as $f) {
        if(preg_match('/\.(mp4|mkv|webm)$/i', $f)) $count++;
    }
    return $count;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nonton Anime - Stream Your Favorites</title>
    <link rel="stylesheet" href="assets/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>

    <header>
        <div class="container header-content">
            <a href="index.php" class="logo">Nonton<span>Anime</span></a>
            
            <div class="header-right">
                <div class="search-box">
                    <input type="text" placeholder="Search anime...">
                    <button><i class="fas fa-search"></i></button>
                </div>
                <div class="theme-switch-wrapper">
                    <label class="theme-switch" for="checkbox">
                        <input type="checkbox" id="checkbox" />
                        <div class="slider">
                            <i class="fas fa-sun slider-icon sun-icon"></i>
                            <i class="fas fa-moon slider-icon moon-icon"></i>
                        </div>
                    </label>
                </div>
            </div>
        </div>
    </header>

    <?php if ($heroAnime): 
        $heroPath = $dir . '/' . $heroAnime;
        $heroPoster = getPoster($heroPath);
        $heroEps = getEpisodeCount($heroPath);
    ?>
    <!-- Hero Section -->
    <section class="hero" style="background-image: url('<?php echo htmlspecialchars($heroPoster); ?>');">
        <div class="hero-overlay"></div>
        <div class="container hero-content">
            <span class="badge mb-2">Featured</span>
            <h1 class="hero-title"><?php echo htmlspecialchars($heroAnime); ?></h1>
            <p class="hero-meta">
                <span><i class="fas fa-play-circle"></i> <?php echo $heroEps; ?> Episodes</span>
                <span><i class="fas fa-star"></i> Trending</span>
            </p>
            <p class="hero-desc">
                Watch the latest episodes of <?php echo htmlspecialchars($heroAnime); ?> in high quality. 
                Stream now on NontonAnime.
            </p>
            <div class="hero-actions">
                <a href="watch.php?anime=<?php echo urlencode($heroAnime); ?>&ep=1" class="btn btn-primary btn-lg">
                    <i class="fas fa-play"></i> Watch Now
                </a>
                <button class="btn btn-secondary btn-lg">
                    <i class="fas fa-plus"></i> My List
                </button>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <main class="container">
        
        <!-- Categories -->
        <section class="mb-4">
            <div class="category-list">
                <button class="cat-btn active" data-filter="all">All</button>
                <button class="cat-btn" data-filter="action">Action</button>
                <button class="cat-btn" data-filter="adventure">Adventure</button>
                <button class="cat-btn" data-filter="fantasy">Fantasy</button>
                <button class="cat-btn" data-filter="isekai">Isekai</button>
                <button class="cat-btn" data-filter="comedy">Comedy</button>
            </div>
        </section>

        <!-- Main Grid -->
        <section class="mb-5">
            <div class="section-title">
                Latest Updates
                <a href="#" class="view-all">View All <i class="fas fa-chevron-right"></i></a>
            </div>

            <div class="anime-grid" id="anime-grid">
                <?php if (empty($mainList)): ?>
                    <div class="col-12 text-center text-secondary">No anime found. Add folders to "animes/".</div>
                <?php else: ?>
                    <?php foreach ($mainList as $animeTitle): 
                        $path = $dir . '/' . $animeTitle;
                        $poster = getPoster($path);
                        $episodes = getEpisodeCount($path);
                        // Mock category for filtering demo - logic could be improved
                        $mockCat = 'action'; 
                        if (stripos($animeTitle, 'adventure') !== false) $mockCat .= ' adventure';
                        if (stripos($animeTitle, 'fantasy') !== false) $mockCat .= ' fantasy';
                    ?>
                    <a href="watch.php?anime=<?php echo urlencode($animeTitle); ?>&ep=1" 
                       class="anime-card group" 
                       data-title="<?php echo htmlspecialchars(strtolower($animeTitle)); ?>"
                       data-category="<?php echo $mockCat; ?>">
                        <div class="poster-wrapper">
                            <img src="<?php echo htmlspecialchars($poster); ?>" alt="<?php echo htmlspecialchars($animeTitle); ?>" class="poster-img">
                            <div class="overlay">
                                 <div class="play-btn">
                                     <i class="fas fa-play" style="margin-left:4px;"></i>
                                 </div>
                            </div>
                            <span class="badge">TV</span>
                            <span class="ep-badge">Ep <?php echo $episodes; ?></span>
                        </div>
                        <div class="card-info">
                            <h3 class="card-title"><?php echo htmlspecialchars($animeTitle); ?></h3>
                        </div>
                    </a>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </section>

        <!-- Recommendations -->
        <?php if (!empty($recommendations)): ?>
        <section class="mb-5">
            <div class="section-title">
                Recommended for You
            </div>
            <div class="anime-grid">
                <?php foreach ($recommendations as $recTitle): 
                    $path = $dir . '/' . $recTitle;
                    $poster = getPoster($path);
                    $eps = getEpisodeCount($path);
                ?>
                <a href="watch.php?anime=<?php echo urlencode($recTitle); ?>&ep=1" class="anime-card group">
                    <div class="poster-wrapper">
                        <img src="<?php echo htmlspecialchars($poster); ?>" alt="<?php echo htmlspecialchars($recTitle); ?>" class="poster-img">
                        <div class="overlay">
                             <div class="play-btn">
                                 <i class="fas fa-play" style="margin-left:4px;"></i>
                             </div>
                        </div>
                        <span class="badge">Hot</span>
                        <span class="ep-badge">Ep <?php echo $eps; ?></span>
                    </div>
                    <div class="card-info">
                        <h3 class="card-title"><?php echo htmlspecialchars($recTitle); ?></h3>
                    </div>
                </a>
                <?php endforeach; ?>
            </div>
        </section>
        <?php endif; ?>

    </main>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-brand">
                    <a href="index.php" class="logo">Nonton<span>Anime</span></a>
                    <p class="text-secondary mt-2">Free anime streaming platform.</p>
                </div>
                <div class="footer-links">
                    <h3>Legal</h3>
                    <ul>
                        <li><a href="#">Terms of Service</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">DMCA</a></li>
                    </ul>
                </div>
                <div class="footer-links">
                    <h3>Social</h3>
                    <ul>
                        <li><a href="#">Discord</a></li>
                        <li><a href="#">Twitter</a></li>
                        <li><a href="#">Instagram</a></li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> NontonAnime. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="assets/script.js"></script>
</body>
</html>
