document.addEventListener('DOMContentLoaded', () => {

    // --- Theme Toggle ---
    const toggleSwitch = document.querySelector('.theme-switch input[type="checkbox"]');
    const body = document.body;

    // Check saved preference
    const savedTheme = localStorage.getItem('theme');
    if (savedTheme === 'light') {
        body.classList.add('light-mode');
        toggleSwitch.checked = true;
    }

    toggleSwitch.addEventListener('change', function (e) {
        if (e.target.checked) {
            body.classList.add('light-mode');
            localStorage.setItem('theme', 'light');
        } else {
            body.classList.remove('light-mode');
            localStorage.setItem('theme', 'dark');
        }
    });


    // --- Category Filtering ---
    const catBtns = document.querySelectorAll('.cat-btn');
    const cards = document.querySelectorAll('.anime-card');

    catBtns.forEach(btn => {
        btn.addEventListener('click', () => {
            // Remove active class
            catBtns.forEach(b => b.classList.remove('active'));
            btn.classList.add('active');

            const filter = btn.dataset.filter;

            cards.forEach(card => {
                if (filter === 'all') {
                    card.style.display = 'flex';
                    return;
                }

                const categories = card.dataset.category || '';
                if (categories.includes(filter)) {
                    card.style.display = 'flex';
                } else {
                    card.style.display = 'none';
                }
            });
        });
    });

});
