<?php
require __DIR__ . '/PHPMailer-6.11.1/src/Exception.php';
require __DIR__ . '/PHPMailer-6.11.1/src/PHPMailer.php';
require __DIR__ . '/PHPMailer-6.11.1/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// ===== Konfigurasi =====
const SMTP_HOST        = 'mail.privateemail.com';
const SMTP_PORT        = 587;                 // 465 jika SSL
const SMTP_SECURE      = 'tls';               // 'ssl' untuk 465
const SMTP_USERNAME    = 'no-reply@indohideout.com';
const SMTP_PASSWORD    = '@Indohideout123';   // sebaiknya pindah ke .env
const TO_EMAIL         = 'no-reply@indohideout.com';
const TO_NAME          = 'INDO HIDEOUT Inbox';
const SUPPORT_EMAIL    = 'support@indohideout.com'; // opsional
const ENABLE_AUTOREPLY = true;

header('Content-Type: application/json; charset=utf-8');

$raw  = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!is_array($data)) { http_response_code(400); echo json_encode(['ok'=>false,'msg'=>'Invalid JSON']); exit; }

$name     = trim($data['name'] ?? '');
$email    = trim($data['email'] ?? '');
$message  = trim($data['message'] ?? '');
$page     = trim($data['page'] ?? '');
$ua       = trim($data['ua'] ?? '');
$honeypot = trim($data['website'] ?? '');     // ← honeypot dari form
$ip       = $_SERVER['REMOTE_ADDR'] ?? '';

if ($honeypot !== '') { echo json_encode(['ok'=>true,'msg'=>'Thanks']); exit; } // diam-diam sukses
if ($name === '' || $email === '') { http_response_code(422); echo json_encode(['ok'=>false,'msg'=>'Nama & email wajib diisi']); exit; }
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) { http_response_code(422); echo json_encode(['ok'=>false,'msg'=>'Format email tidak valid']); exit; }

// ===== Helper untuk set SMTP + UTF-8 =====
function makeMailer(): PHPMailer {
  $m = new PHPMailer(true);
  $m->isSMTP();
  $m->Host       = SMTP_HOST;
  $m->SMTPAuth   = true;
  $m->Username   = SMTP_USERNAME;
  $m->Password   = SMTP_PASSWORD;
  $m->SMTPSecure = SMTP_SECURE;
  $m->Port       = SMTP_PORT;
  $m->CharSet    = 'UTF-8';       // perbaiki “â€”” dsb.
  $m->Encoding   = 'base64';      // aman untuk emoji/garis panjang
  $m->isHTML(true);
  return $m;
}

try {
  // --- kirim ke inbox kamu ---
  $mail = makeMailer();
  $mail->setFrom(SMTP_USERNAME, 'INDO HIDEOUT (No-Reply)');
  $mail->addAddress(TO_EMAIL, TO_NAME);
  $mail->addReplyTo($email, $name); // agar bisa langsung di-reply ke user

  $mail->Subject = "📩 Pesan Contact — {$name}";
  $mail->Body    =
    "<h3>Form Contact INDO HIDEOUT</h3>".
    "<p><b>Nama:</b> ".htmlspecialchars($name)."</p>".
    "<p><b>Email:</b> ".htmlspecialchars($email)."</p>".
    "<p><b>Pesan:</b><br>".nl2br(htmlspecialchars($message))."</p>".
    "<hr>".
    "<p><b>IP:</b> ".htmlspecialchars($ip)."<br><b>UA:</b> ".htmlspecialchars($ua)."<br><b>Page:</b> ".htmlspecialchars($page)."</p>";
  $mail->AltBody = "Nama: $name\nEmail: $email\n\nPesan:\n$message\n\nIP: $ip\nUA: $ua\nPage: $page";
  $mail->send();

  // --- auto-reply ke pengirim ---
  if (ENABLE_AUTOREPLY) {
    $auto = makeMailer();
    $auto->setFrom(SMTP_USERNAME, 'IndoHideout Support (No-Reply)');
    $auto->addAddress($email, $name);
    if (SUPPORT_EMAIL) $auto->addReplyTo(SUPPORT_EMAIL, 'IndoHideout Support'); // jika user balas, masuk ke support

    $auto->Subject = 'no-reply@IndoHideout';
    $auto->Body = nl2br(
      "Halo,\nTerima kasih telah menghubungi kami.\n".
      "Ini adalah balasan otomatis untuk mengonfirmasi bahwa pesan Anda telah masuk ke sistem kami.\n\n".
      "Kami akan segera menindaklanjuti melalui email resmi support kami.\n".
      "Mohon jangan membalas ke email ini.\n\n".
      "Hormat kami,\nIndoHideout Support"
    );
    $auto->AltBody =
      "Halo,\nTerima kasih telah menghubungi kami.\n".
      "Ini adalah balasan otomatis untuk mengonfirmasi bahwa pesan Anda telah masuk ke sistem kami.\n\n".
      "Kami akan segera menindaklanjuti melalui email resmi support kami.\n".
      "Mohon jangan membalas ke email ini.\n\n".
      "Hormat kami,\nIndoHideout Support";

    $auto->send();
  }

  echo json_encode(['ok'=>true,'msg'=>'Terkirim']);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'msg'=>'Mailer Error: '.$e->getMessage()]);
}
